% ******
%   UFPEL.cls
%   LaTeX Class para os livros de Ciências Exatas da UFPEL 
% ******
%   Elaborado por Editora Pi -- contato@editorapi.com.br
% ******

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{UFPELClass}[2021/07/22 LaTeX class livros UFPEL]

% *** CARREGAR PACOTES ***
\RequirePackage{graphicx}
\RequirePackage{xcolor}

\RequirePackage{tikz}
\usetikzlibrary{positioning, shapes.misc}




% *** FONTES ***
\RequirePackage[scaled=0.9]{helvet} % Carregar a fonte Helvetica e escalá-la
\renewcommand{\sfdefault}{phv} % Definir Helvetica como fonte sans-serif padrão

% *** CORES DA MARCA UFPEL ***
\definecolor{verde}{RGB}{190,210,0}
\definecolor{laranja}{RGB}{245,165,0}%cor do titulo
\definecolor{azul}{RGB}{0,65,140}
\definecolor{azulzinho}{RGB}{180,220,240}
\definecolor{amarelo}{RGB}{250,210,0}
\definecolor{vermelho}{RGB}{190,15,15}



% *** FRONT MATTER ***
\newcommand{\@Capa}{%
    \tikz[remember picture, overlay] {%
        \node at (current page.center) {\includegraphics[width=\paperwidth, height=\paperheight]{Iniciais&Finais/Capa.pdf}};
    }
    \newpage~\newpage
}

\newcommand{\@FalsaFolhaRosto}{
    \tikz[remember picture, overlay]{
        \node at (current page.center) {\includegraphics[width=\paperwidth, height=\paperheight]{Iniciais&Finais/FalsoRosto.pdf}};
    }
    \newpage
}

\newcommand{\@PExpediente}{
    \tikz[remember picture, overlay]{
        \node at (current page.center) {\includegraphics[width=\paperwidth, height=\paperheight]{Iniciais&Finais/PrimeiroExpediente.pdf}};
    }
    \newpage
}

\newcommand{\@FolhaRosto}{
    \tikz[remember picture, overlay] {%
        \node at (current page.center) {\includegraphics[width=1.05\paperwidth, height=1.05\paperheight]{Iniciais&Finais/Rosto.pdf}};
    }
    \newpage
}

\newcommand{\@SExpediente}{
    \tikz[remember picture, overlay]{
        \node at (current page.center) {\includegraphics[width=\paperwidth, height=\paperheight]{Iniciais&Finais/SegundoExpediente.pdf}};
    }
    \newpage
}

% *** BACK MATTER ***
\newcommand{\@contracapa}{
    \tikz[remember picture, overlay] {%
        \node at (current page.center) {\includegraphics[width=\paperwidth, height=\paperheight]{Iniciais&Finais/Contracapa.pdf}};
    }
}



% *** OPÇÕES DE CLASSE ***
\DeclareOption{ebook}{%
    \graphicspath{{Figuras/Coloridas/}{Figuras/}}%folder for colored figures
    \AtBeginDocument{
        \RequirePackage{ifoddpage}
        \pagestyle{empty}
        \frontmatter	
        \setcounter{page}{-1}
        \@Capa % inclui a capa 
        \@FalsaFolhaRosto % inclui a Falsa Folha de Rosto 
        \@PExpediente % inclui Copywrite 
        \@FolhaRosto % inclui a Folha de Rosto
        \@SExpediente
        \pagestyle{headings}
    }
    \AtEndDocument{%
        \pagestyle{empty}
        \checkoddpage
        \@ifoddpage{}{~}
        \newpage~\newpage
        \@contracapa% inclui a contracapa no final do documento. 
    }
}

\DeclareOption{grafica}{%
    \graphicspath{{Figuras/Preto&Branco}{Figuras/}} %folder for grayscale figures
    \colorlet{verde}{black}
    \colorlet{laranja}{black}
    \colorlet{verde}{black}
    \colorlet{azul}{black}
    \colorlet{azulzinho}{black}
    \colorlet{amarelo}{black}
    \colorlet{vermelho}{black}
    

    \AtBeginDocument{
        \RequirePackage[a4,center,cam,info]{crop}
        \RequirePackage{ifoddpage}
        \pagestyle{empty}
        \frontmatter	
        \setcounter{page}{1}
        \@FalsaFolhaRosto % inclui a Falsa Folha de Rosto 
        \@PExpediente % inclui Copywrite 
        \@FolhaRosto % inclui a Folha de Rosto
        \@SExpediente
        \pagestyle{headings}
    }
    \AtEndDocument{%
        \checkoddpage
        \@ifoddpage{}{~\thispagestyle{empty}}
    }
}


\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ProcessOptions
\LoadClass[11pt]{book}

% *** MEDIDAS ***
\RequirePackage[twoside, paperwidth=180mm, paperheight=250mm, left=20mm, right=15mm, top=20mm, bottom=20mm, headsep=8mm, centering]{geometry}


% *** CABEÇALHOS ***
\let\MakeUppercase=\relax % para letra minúscula nos cabeçalhos do Sumário, da Bibliografia e do Índice Remissivo (frontmatter e backmatter)
\def\ps@headings{
    \def\@oddfoot{\hfil\footnotesize\fontfamily{\sfdefault}\selectfont\thepage}
    \def\@evenfoot{\footnotesize\fontfamily{\sfdefault}\selectfont\thepage\hfil}
    \def\@evenhead{\footnotesize\fontfamily{\sfdefault}\selectfont\leftmark\hfil}%
    \def\@oddhead{\hfil\footnotesize\fontfamily{\sfdefault}\selectfont\rightmark}%

    \def\chaptermark##1{%
        \markboth{%
            \ifnum \c@secnumdepth >\m@ne
                \if@mainmatter
                    {%\@chapapp~
                    \thechapter.~}%
                \fi
            \fi
        {{##1}}
        }{}
    }%
  
    \def\sectionmark##1{%
        \markright {%
            \ifnum\c@secnumdepth >\z@
                {\thesection.}%
            \fi
            ~
            {##1}~
        }%
    }%
}

% número de página na apresentação dos capítulos 
\def\ps@plain{
    \let\@oddhead\@empty
    \let\@evenhead\@empty
    \def\@oddfoot{\hfil\footnotesize\fontfamily{\sfdefault}\selectfont\thepage}
    \let\@evenfoot\@oddfoot
}

% *** CAPÍTULOS ***
\let\@nota\@empty
\def\@makechapterhead#1{%
    \vspace*{1cm}%
    \hfill
    {\bfseries\fontsize{35}{35}\fontfamily{\sfdefault}\selectfont\@chapapp~\thechapter\endgraf}
    \vspace*{.5cm}
    
    \hfill
    \begin{tikzpicture}
        \node[text width=.8\textwidth, align=flush right]  at (0,0) {\bfseries\fontsize{25}{25}\fontfamily{\sfdefault}\selectfont{#1}\endgraf};
    \end{tikzpicture}
    
    \vspace*{1cm}
    \hfill
    \begin{tikzpicture}
        \node[text width=.75\textwidth,align=flush right]  at (0,0) {\fontsize{12}{12}\fontfamily{\sfdefault}\selectfont\@nota\endgraf};
    \end{tikzpicture}
    \let\@nota\@empty
    \vspace*{1cm}
}

\newcommand\cita[1]{\renewcommand\@nota{#1}}

% unnumbered chapter headings
\def\@makeschapterhead#1{%
    \vspace*{1.0cm}%
    \hfill
    {\bfseries\fontsize{35}{35}\fontfamily{\sfdefault}\selectfont{#1}\endgraf}
    \vspace*{1.5cm}
}

% *** SEÇÕES, SUBSEÇÕES ETC ***
\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\Large\bfseries\fontfamily{\sfdefault}\selectfont}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\large\bfseries\fontfamily{\sfdefault}\selectfont}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalsize\bfseries\fontfamily{\sfdefault}\selectfont}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\footnotesize\bfseries\fontfamily{\sfdefault}\selectfont}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                      {\footnotelsize\bfseries\fontfamily{\sfdefault}\selectfont}}

% *** MISCELÂNEAS ***
\newcommand{\email}[1]{\href{mailto:#1}{#1}}
\newcommand{\webpage}[1]{\url{#1}}
\newcommand{\citacao}[1]{
    \begin{flushright}
    \begin{minipage}{12cm}
    \fontsize{10pt}{10pt}\selectfont
    #1
    \end{minipage}
    \end{flushright}
}


% caption de figuras com fonte dos títulos e pequena
\RequirePackage{subcaption}
\DeclareCaptionFormat{custom_UFPEL}
{\medskip
{\footnotesize\fontfamily{\sfdefault}\selectfont\bfseries\textbf{#1#2}}{\small{#3}}}
\captionsetup{format=custom_UFPEL}




\RequirePackage[hidelinks,breaklinks,bookmarksopen=true]{hyperref}
%\RequirePackage[linktocpage=true, breaklinks=true, bookmarksopen=true]{hyperref}
%\RequirePackage{url}
\hypersetup{
    colorlinks=true,
    linkcolor=azul,
    filecolor=azulzinho,      
    urlcolor=verde,
    citecolor=laranja,
%    pdfpagemode=FullScreen,
    }
\urlstyle{same}


% ****************
\endinput
% ****************
